#!/bin/bash

function aide ()
{
cat <<EOF
Ce script permet d'enregistrer les chaines de la freebox
USAGE
        $0 [OPTION]
OPTIONS
        -d      Duréde l'enregistrement en seconde
                3600  = 1h
                7200  = 2h
                10800 = 3h
                14400 = 4h

        -c      Chaine a enregistrer, ci-dessous les chaines disponibles

        -z      Compression

EOF
grep rtsp $0 |  awk '{print $4}' | sed s/\"//g | grep -v ]
}


while getopts "hzd:c:" opt; do
case $opt in
        d ) duration=$OPTARG;;
        c ) channel=$OPTARG;;
        z ) compression="yes";;
        h )
        ( aide )
        exit 1 ;;
esac
done

VLC="/usr/bin/vlc"
FFMPEG="/usr/bin/ffmpeg"

##### ENREGISTREMENT #####
if [ "$channel" ]
then
        [[ "$channel" = "W9" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/373"
        [[ "$channel" = "M6Rock" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/431"
        [[ "$channel" = "France2" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/201"
        [[ "$channel" = "France3" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/202"
        [[ "$channel" = "France5" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/203"
        [[ "$channel" = "NT1" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/374"
        [[ "$channel" = "BFM" ]] && FLUX="rtsp://mafreebox.freebox.fr/freeboxtv/418"
        #DST="/mnt/share/freetv/${channel}_`date +%F-%H%M`.avi"
        filename=${channel}_`date +%F-%H%M`
        DST="/mnt/share/freetv/${filename}.ps"

        /etc/network/iptables-stop.sh

        echo "Launching VLC recorder for "$DURATION"s"
        $VLC --intf dummy --play-and-stop --sout "#standard{access=file,mux=ps,url="$DST"}" --sout-transcode-fps=15 --extraintf=http --http-host="127.0.0.1:8088" --no-sout-display $FLUX &

        sleep 15
        
        /etc/network/iptables-start.sh

        PID=$!
        if [ "$duration" ]
        then
                DURATION=$duration
                sleep $DURATION
                curl -s "http://127.0.0.1:8088/requests/status.xml?command=pl_stop"
                if [ $? == 0 ]; then
                        echo "VLC stopped gracefully"
                else
                        echo "VLC didn't stopped correctly"
                        # coller syslog ici
                fi
                sleep 3
                echo "Killing VLC after cooling pause"
                kill -9 $PID
        else
                echo $PID
        fi
else
        echo "Aucune Chaine n'a ete defini ou la chaine n'est pas reference dans le script"
        echo "chaines disponibles :"
        grep rtsp $0 |  awk '{print $4}' | sed s/\"//g
fi

##### COMPRESSION #####
if [ "$compression" = "yes" ]
then
        bitrate=500
        son=22050
        #resolution=320x240
        resolution=640x480
        $FFMPEG -i $DST -ar $son -b $bitrate -s $resolution /mnt/share/freetv/${filename}.mpg
        rm -f $DST
fi
