#!/bin/bash

#set -x
if [ "$1" = "" ]
then
cat <<EOF
Merci de preciser la nature de la sauvgarde : system ou data
  - Pour sauvegarde uniquement le systeme, lancer : $0 system
  - Pour sauvegarde uniquement les donnees, lancer : $0 data
EOF
exit
fi


# Definition de la date de la sauvegarde
BACKUP_DATE=$(date +%Y%m%d)

# Repertoire de depot des sauvegardes
BACKUP_DESTINATION="/media/backup"

# LABEL du disque USB
DISK_LABEL="BACKUP"

# Definition du nom de la sauvegarde systeme
BACKUP_PREFIX_SYS="backup_sys_${HOSTNAME}"
BACKUP_NAME_SYS=${BACKUP_PREFIX_SYS}_${BACKUP_DATE}

# Definition des noms des sauvegardes donnees
BACKUP_PREFIX_DATA="backup_data_${HOSTNAME}"
BACKUP_NAME_DATA=${BACKUP_PREFIX_DATA}_${BACKUP_DATE}

BACKUP_PREFIX_MYSQL="Export_Mysql"
BACKUP_NAME_MYSQL="${BACKUP_PREFIX_MYSQL}_${BACKUP_DATE}"

BACKUP_PREFIX_LDAP="Export_LDAP"
BACKUP_NAME_LDAP="${BACKUP_PREFIX_LDAP}_${BACKUP_DATE}"

# Durée de rétention de la sauvegarde système (en jour)
BACKUP_RET_SYS=15

# Durée de rétention de la sauvegarde données (en jour)
BACKUP_RET_DATA=30

# Adresse Email d'alerte
#EMAIL_ALERT="root"
#EMAIL_ALERT="grondin.arda@wanadoo.fr"
EMAIL_ALERT="benoit.saglietto@avantgarde-dom.com"

# Mot de passe root de la base MySQL
MYSQL_PASSWD=""

#---------------- MONTAGE DU DISQUE -----------------------#
umount ${BACKUP_DESTINATION}
mount -L ${DISK_LABEL} ${BACKUP_DESTINATION}
rc=$?
if [ "$rc" != "0" ]
then
  echo "La sauvegarde sur $HOSTNAME n'a pas ete lance car le disque USB identifie sous le label $DISK_LABEL n'a pas pu etre monte dans $BACKUP_DESTINATION"
  echo "La sauvegarde sur $HOSTNAME n'a pas ete lance car le disque USB identifie sous le label $DISK_LABEL n'a pas pu etre monte dans $BACKUP_DESTINATION" |mail -s "LA SAUVEGARDE N'A PAS ETE LANCE SUR $HOSTNAME" ${EMAIL_ALERT}
  exit 1
fi
#---------------- FIN MONTAGE DU DISQUE -------------------#

#---------------- SAUVEGARDE DU SYSTEME -------------------#
if [ "$1" = "system" ]
then
  tar czfv ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.tar.gz --exclude ${BACKUP_DESTINATION} --exclude /home --exclude /dev --exclude /proc --exclude /sys / > ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log 2>&1 
  rcsys=$?
  if [ "$rcsys" != "0" ]
  then
    echo "-------------------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
    echo "ERREUR DE SAUVEGARDE SYSTEME - Voir log ci-dessus" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
    echo "-------------------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
    echo "La sauvegarde s'est termimnee en erreur. Merci de consulter le fichier log : ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log sur $HOSTNAME" |mail -s "ERREUR DE SAUVEGARDE SYSTEME sur $HOSTNAME" ${EMAIL_ALERT}
  else
    echo "----------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
    echo "SAUVEGARDE OK - Voir log ci-dessus" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
    echo "----------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
    echo "La sauvegarde s'est termimnee avec succes. Vous pouvez consulter le fichier log : ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log sur $HOSTNAME" | mail -s "SAUVEGARDE SYSTEME OK sur $HOSTNAME" ${EMAIL_ALERT}
  fi

  # Suppression des sauvegardes systeme anciennes
  echo "Les anciennes sauvegardes systeme suivantes ont ete supprimees :" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
  find ${BACKUP_DESTINATION} -type f -name "${BACKUP_PREFIX_SYS}*" -mtime +${BACKUP_RET_SYS} -exec rm -fv {} \; >> ${BACKUP_DESTINATION}/${BACKUP_NAME_SYS}.log
fi
#------------ FIN SAUVEGARDE DU SYSTEME -------------------#



#---------------- SAUVEGARDE DES DONNEES ------------------#
if [ "$1" = "data" ]
then

  # Sauvegarde des bases de donnees
  /usr/bin/mysqldump -u root -A -p${MYSQL_PASSWD} |gzip > /$BACKUP_DESTINATION/${BACKUP_NAME_MYSQL}.sql.gz
  rcmysql=$?
  if [ "$rcmysql" != "0" ]
  then
    echo "------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "Erreur de sauvegarde des bases MySQL" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  else
    echo "------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "Sauvegarde des bases MySQL : OK     " >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  fi

  # Sauvegarde de l'annuaire LDAP
  /usr/sbin/slapcat > /$BACKUP_DESTINATION/${BACKUP_NAME_LDAP}.ldif.gz
  rcldap=$?
  if [ "$rcldap" != "0" ]
  then
    echo "---------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "Erreur de sauvegarde de l'annuaire LDAP" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "---------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  else
    echo "---------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "Sauvegarde de l'annuaire LDAP: OK      " >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "---------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  fi

  # Sauvegarde des fichiers
  tar czfv ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.tar.gz --exclude ${BACKUP_DESTINATION} /home >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log 2>&1 
  rcfiles=$?
  if [ "$rcfiles" != "0" ]
  then
    echo "--------------------------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "Erreur de sauvegarde des donnees, voir details ci-dessus" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "--------------------------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  else
    echo "--------------------------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "Sauvegarde des donnees : OK (voir detail ci-dessus)     " >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
    echo "--------------------------------------------------------" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  fi

  # Envoi de l'alerte des sauvegarde 
  if [ $rcmysql != "0" -o $rcldap != "0" -o $rcfiles != "0" ]
  then
     echo "La sauvegarde s'est termimnee en erreur. Merci de consulter le fichier log : ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log sur $HOSTNAME" |mail -s "ERREUR DE SAUVEGARDE DONNEES sur $HOSTNAME" ${EMAIL_ALERT}
  else
    echo "La sauvegarde s'est termimnee avec succes. Vous pouvez consulter le fichier log : ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log sur $HOSTNAME" |mail -s "SAUVEGARDE DONNEES OK sur $HOSTNAME" ${EMAIL_ALERT}
  fi

  # Suppression des  sauvegardes donnee anciennes
  echo "Les anciennes sauvegardes donnees suivantes ont ete supprimees :" >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  find ${BACKUP_DESTINATION} -type f -name "${BACKUP_PREFIX_DATA}*" -mtime +${BACKUP_RET_DATA} -exec rm -fv {} \; >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  find ${BACKUP_DESTINATION} -type f -name "${BACKUP_PREFIX_MYSQL}*" -mtime +${BACKUP_RET_DATA} -exec rm -fv {} \; >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
  find ${BACKUP_DESTINATION} -type f -name "${BACKUP_PREFIX_LDAP}*" -mtime +${BACKUP_RET_DATA} -exec rm -fv {} \; >> ${BACKUP_DESTINATION}/${BACKUP_NAME_DATA}.log
fi
#------------ FIN SAUVEGARDE DES DONNEES ------------------#



#------------ DEMONTAGE DU DISQUE USB ---------------------#
cd
umount /media/backup
#------------ FIN DEMONTAGE DU DISQUE USB -----------------#
